<HTML>
	<HEAD>
		<META http-equiv='Content-Language' content='en-us'>
		<META http-equiv='Content-Type' content='text/html; charset=UTF-8'>
		<META http-equiv='ImageToolbar' content='no'>

		<META name='Author' content='Melissa Data Corporation'>
		<META name='Description' content='mdName API: Name parsing example.'>

		<TITLE>mdName API: Name Parsing Example</TITLE>
	</HEAD>

	<?PHP

		//********************************************************************************
		//If you should have any comments, suggestions or improvements to these samples,
		//we welcome you to contact us at SampleCode@melissadata.com also please visit our
		//developers bulletin board at forum.melissadata.com.
		//********************************************************************************

		// Change the following lines to reflect your installation location
		//   of the mdName API and the license string:
		// The Data Files Directory must contain the following files: mdName.dat and mdName.cfg.
		$dFILELOC="C:\\Program Files\\Melissa DATA\\DQT\\Data";

		//********************** LICENSE STRINGS ***********************
		//*     To unlock the full functionality of Name Object,       *
		//*     	     Or to obtain a Demo License String            *
		//* please call a sales representative at 1-800-MELISSA ext. 3 *
		//*         (1-800-635-4772 x3) for a license string.          *
		//*************************************************************/

		$dLICENSE="DEMO";

		// We have results from a POSTed form, split the provided name:
		if (!empty($_POST) && !empty($_POST["FullName"])) {

			$FullName=$_POST["FullName"];

			$Name=mdNameCreate();
			if ($Name==0) {
				echo 'Bad $Name';
				return;
			}

			if (mdNameSetLicenseString($Name,$dLICENSE)==0) {
				echo 'Error setting License to "'.$dLICENSE.'" <br>';
				echo 'To unlock full functionality or to obtain a Demo License String, please call';
				echo 'our representatives at 1-800-MELISSA ext 3';
				return;
			}

			mdNameSetPathToNameFiles($Name,$dFILELOC);
			if (mdNameInitializeDataFiles($Name)!=0) {
				echo 'Error Initializing mdName: "'.
					mdNameGetInitializeErrorString($Name).'"';
				return;
			}

			mdNameSetPrimaryNameHint($Name,2);
			mdNameSetFirstNameSpellingCorrection($Name,1);
			mdNameSetSalutationPrefix($Name,"Dear");
			mdNameSetSalutationSuffix($Name,":");
			mdNameSetSalutationSlug($Name,"Valued Customer");

			mdNameSetFullName($Name,$FullName);
			mdNameParse($Name);

			$Gender=mdNameGetGender($Name);
			$Prefix=mdNameGetPrefix($Name);
			$FirstName=mdNameGetFirstName($Name);
			$MiddleName=mdNameGetMiddleName($Name);
			$LastName=mdNameGetLastName($Name);
			$Suffix=mdNameGetSuffix($Name);
			$Gender2=mdNameGetGender2($Name);
			$Prefix2=mdNameGetPrefix2($Name);
			$FirstName2=mdNameGetFirstName2($Name);
			$MiddleName2=mdNameGetMiddleName2($Name);
			$LastName2=mdNameGetLastName2($Name);
			$Suffix2=mdNameGetSuffix2($Name);
			$Salutation=mdNameGetSalutation($Name);
			$StatusCode=mdNameGetStatusCode($Name);
			$ErrorCode=mdNameGetErrorCode($Name);
			$ChangeCode=mdNameGetChangeCode($Name);

			mdNameDestroy($Name);

		} else {
			$FullName="Mr. John Smith Phd.";
			$Gender="";
			$Prefix="";
			$FirstName="";
			$MiddleName="";
			$LastName="";
			$Suffix="";
			$Gender2="";
			$Prefix2="";
			$FirstName2="";
			$MiddleName2="";
			$LastName2="";
			$Suffix2="";
			$Salutation="";
			$StatusCode="";
			$ErrorCode="";
			$ChangeCode="";
		}
	?>

	<BODY>
		<TABLE border='0' cellpadding='0' cellspacing='0' width='745'>
			<TR>
				<TD background='background.gif' height='59'>
					<a href='http://www.melissadata.com'><img border='0' src='melissadata.gif' width='218' height='21'>
				</TD>
			</TR>
			<TR style='font-family:arial;font-size:110%;color:white'>
				<TD align='center' background='background.gif' colspan='4' height='30'><B>mdName API: Name Parsing Example</B></TD>
			</TR>
		</TABLE>

		<FORM method='post' action="mdNameExample.php">
			<TABLE width='800' style='font-family:arial;font-size:80%'>
				<TR><TD>&nbsp;</TD></TR>
				<TR>
					<TD colspan='2'><B>Input:</B></TD>
					<TD>&nbsp;</TD>
					<TD colspan='2'><B>Parsed Results:</B></TD>
				</TR>
				<TR>
					<TD align='right'>Full Name:</TD>
					<TD><INPUT type='text' name='FullName' size='40' value='<?php echo $FullName ?>'></TD>
					<TD>&nbsp;</TD>
					<TD align='right'>Gender:</TD>
					<TD><INPUT type='text' name='Gender' size='20' value='<?php echo $Gender ?>' disabled></TD>
				</TR>
				<TR>
					<TD colspan='3' align='center'><INPUT type='submit' name='Submit' value='Submit'></TD>
					<TD align='right'>Prefix:</TD>
					<TD><INPUT type='text' name='Prefix' size='20' value='<?php echo $Prefix ?>' disabled></TD>
				</TR>
				<TR>
					<TD colspan='3'>&nbsp;</TD>
					<TD align='right'>First Name:</TD>
					<TD><INPUT type='text' name='FirstName' size='20' value='<?php echo $FirstName ?>' disabled></TD>
				</TR>
				<TR>
					<TD colspan='3'>&nbsp;</TD>
					<TD align='right'>Middle Name:</TD>
					<TD><INPUT type='text' name='MiddleName' size='20' value='<?php echo $MiddleName ?>' disabled></TD>
				</TR>
				<TR>
					<TD colspan='3'>&nbsp;</TD>
					<TD align='right'>Last Name:</TD>
					<TD><INPUT type='text' name='LastName' size='20' value='<?php echo $LastName ?>' disabled></TD>
				</TR>
				<TR>
					<TD colspan='3'>&nbsp;</TD>
					<TD align='right'>Suffix:</TD>
					<TD><INPUT type='text' name='Suffix' size='20' value='<?php echo $Suffix ?>' disabled></TD>
				</TR>
				<TR>
					<TD colspan='3'>&nbsp;</TD>
					<TD align='right'>Gender 2:</TD>
					<TD><INPUT type='text' name='Gender2' size='20' value='<?php echo $Gender2 ?>' disabled></TD>
				</TR>
				<TR>
					<TD colspan='3'>&nbsp;</TD>
					<TD align='right'>Prefix 2:</TD>
					<TD><INPUT type='text' name='Prefix2' size='20' value='<?php echo $Prefix2 ?>' disabled></TD>
				</TR>
				<TR>
					<TD colspan='3'>&nbsp;</TD>
					<TD align='right'>First Name 2:</TD>
					<TD><INPUT type='text' name='FirstName2' size='20' value='<?php echo $FirstName2 ?>' disabled></TD>
				</TR>
				<TR>
					<TD colspan='3'>&nbsp;</TD>
					<TD align='right'>Middle Name 2:</TD>
					<TD><INPUT type='text' name='MiddleName2' size='20' value='<?php echo $MiddleName2 ?>' disabled></TD>
				</TR>
				<TR>
					<TD colspan='3'>&nbsp;</TD>
					<TD align='right'>Last Name 2:</TD>
					<TD><INPUT type='text' name='LastName2' size='20' value='<?php echo $LastName2 ?>' disabled></TD>
				</TR>
				<TR>
					<TD colspan='3'>&nbsp;</TD>
					<TD align='right'>Suffix 2:</TD>
					<TD><INPUT type='text' name='Suffix2' size='20' value='<?php echo $Suffix2 ?>' disabled></TD>
				</TR>
				<TR>
					<TD colspan='3'>&nbsp;</TD>
					<TD align='right'>Salutation:</TD>
					<TD><INPUT type='text' name='Salutation' size='20' value='<?php echo $Salutation ?>' disabled></TD>
				</TR>

				<TR>
					<TD colspan='3'>&nbsp;</TD>
					<TD align='right'>Status Code:</TD>
					<TD><INPUT type='text' name='StatusCode' size='20' value='<?php echo $StatusCode ?>' disabled></TD>
				</TR>
				<TR>
					<TD colspan='3'>&nbsp;</TD>
					<TD align='right'>Error Code:</TD>
					<TD><INPUT type='text' name='ErrorCode' size='20' value='<?php echo $ErrorCode ?>' disabled></TD>
				</TR>
				<TR>
					<TD colspan='3'>&nbsp;</TD>
					<TD align='right'>Change Code:</TD>
					<TD><INPUT type='text' name='ChangeCode' size='20' value='<?php echo $ChangeCode ?>' disabled></TD>
				</TR>
				<TR><TD>&nbsp;</TD></TR>
			</TABLE>
		</FORM>
	</BODY>
</HTML>